//////////////////////////////////////////////////////////////////
//                     Group Dungeons 1.6 Final                 //
//                           -The Jedi-                         //
//                          RunUO 2.0 RC1                       //
//////////////////////////////////////////////////////////////////

using System;
using Server;
using Server.Network;
using Server.Mobiles;
using System.Collections.Generic;
using System.Collections;
using Server.Spells.Fifth;
using Server.Spells.Seventh;
using Server.Spells.Necromancy;
using Server.Spells.Ninjitsu;
using Server.Spells.Spellweaving;

namespace Server.Items
{
    public class GroupDungeonTeleporter : Teleporter
    {
        private GroupDungeonStone m_Stone;

        [CommandProperty(AccessLevel.GameMaster)]
        public GroupDungeonStone Stone
        {
            get { return m_Stone; }
            set { m_Stone = value; InvalidateProperties(); }
        }

        [Constructable]
		public GroupDungeonTeleporter() : this( new Point3D( 0, 0, 0 ), null, false )
		{
        }

		[Constructable]
		public GroupDungeonTeleporter( Point3D pointDest, Map mapDest ) : this( pointDest, mapDest, false )
		{
        }

        [Constructable]
		public GroupDungeonTeleporter( Point3D pointDest, Map mapDest, bool creatures ) : base( pointDest, mapDest, creatures)
		{
            Name = "an instance zone-in teleporter";
            Hue = 1157;
            Visible = true;
            base.MapDest = this.Map;
            base.PointDest = this.Location;
        }

        public GroupDungeonTeleporter(Serial serial) : base(serial)
		{
            Name = "an instance zone-in teleporter";
            Hue = 1157;
            Visible = true;
            base.MapDest = this.Map;
            base.PointDest = this.Location;
		}

        public override bool OnMoveOver(Mobile m)
        {
            if (m_Stone != null)
            {
                if (m_Stone.IRegion != null)
                {
                    if (m_Stone.IRegion.CanEnter(m))
                        return base.OnMoveOver(m);
                }
                else
                    m.SendMessage(34, "Teleporter not linked to a dungeon region. Contact staff.");
            }
            else
                m.SendMessage(34, "Teleporter not linked to a dungeon stone. Contact staff.");
            return true;
        }

        public override void DoTeleport(Mobile m)
        {
            Map map = base.MapDest;

            if (map == null || map == Map.Internal)
                map = m.Map;

            Point3D p = base.PointDest;

            if (p == Point3D.Zero)
                p = m.Location;

            // Check for AllowPets here
            if (!m_Stone.AllowPets && CountPets(m) > 0)
                m.SendMessage(34, "Se svymi zviraty nemuzes do {0} vstoupit.", m_Stone.DungeonName);
            else if ( !m_Stone.AllowSpells && ( m.IsBodyMod || ArcaneForm.UnderTransformation( m ) || AnimalForm.UnderTransformation( m ) || TransformationSpell.UnderTransformation( m ) || !m.CanBeginAction( typeof( PolymorphSpell ) ) ) )
                m.SendMessage(34, "Nemuzes do {0} vstoupit pokud mas zmenenou podobu.", m_Stone.DungeonName);
            else
            {
              BaseHire hire = BaseHire.HireTable[m] as BaseHire;
              
              if( hire != null && !hire.Deleted && hire.GetOwner() == m && hire is Medic && m.AccessLevel == AccessLevel.Player )
              {
                  m.SendMessage(34, "S najmutym pomocnikem nemuzes do {0} vstoupit.", m_Stone.DungeonName);
              }
              else
              {
                  Server.Mobiles.BaseCreature.TeleportPets(m, p, map);
                      
                  bool sendEffect = (!m.Hidden || m.AccessLevel == AccessLevel.Player);
      
                  if (base.SourceEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  m.MoveToWorld(p, map);
      
                  if (base.DestEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  if (base.SoundID > 0 && sendEffect)
                      Effects.PlaySound(m.Location, m.Map, base.SoundID);
              }
            }
        }

        public int CountPets(Mobile master)
        {
            int count = 0;

            foreach (Mobile m in master.GetMobilesInRange(10))
            {
                if (m is BaseCreature)
                {
                    BaseCreature pet = (BaseCreature)m;

                    if (pet.Controlled && pet.ControlMaster == master)
                        count++;
                }
            }

            return count;
        }
        
        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version

            writer.Write(m_Stone);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 0:
                    {
                        m_Stone = (GroupDungeonStone)reader.ReadItem();
                        break;
                    }
            }
        }
    }

    public class GroupDungeonExit : Teleporter
    {
        [Constructable]
        public GroupDungeonExit()
            : this(new Point3D(0, 0, 0), null, false)
        {
        }

        [Constructable]
        public GroupDungeonExit(Point3D pointDest, Map mapDest)
            : this(pointDest, mapDest, false)
        {
        }

        [Constructable]
        public GroupDungeonExit(Point3D pointDest, Map mapDest, bool creatures)
            : base(pointDest, mapDest, creatures)
        {
            Name = "an instance zone-out teleporter";
            Hue = 1155;
            Visible = false;
            base.MapDest = this.Map;
            base.PointDest = this.Location;
        }

        public GroupDungeonExit(Serial serial)
            : base(serial)
        {
            Name = "an instance zone-out teleporter";
            Hue = 1155;
            Visible = false;
            base.MapDest = this.Map;
            base.PointDest = this.Location;
        }

        public override bool OnMoveOver(Mobile m)
        {
            if (m.Alive && m is PlayerMobile) // Only allow living players to leave.
                return base.OnMoveOver(m);    // This is to wait for rez or wipe.
                    
            return true;
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 0:
                    {
                        break;
                    }
            }
        }
    }
    
    
   public class AuberonTeleporter : GroupDungeonTeleporter
   {
      [Constructable]
		public AuberonTeleporter()
		{
		    Name = "Teleport s kontrolou lahvicky";
      }
      
        public override bool OnMoveOver(Mobile m)
        {
            if ( m == null ) return false;
            
            if (Stone != null)
            {
                if (Stone.IRegion != null)
                {
                    if (Stone.IRegion.CanEnter(m))
                        return base.OnMoveOver(m);
                }
                else
                    m.SendMessage(34, "Teleporter not linked to a dungeon region. Contact staff.");
            }
            else
                m.SendMessage(34, "Teleporter not linked to a dungeon stone. Contact staff.");
            return true;
        }
      
        public override void DoTeleport(Mobile m)
        {
            if ( m == null ) return;
            
            Map map = base.MapDest;

            if (map == null || map == Map.Internal)
                map = m.Map;

            Point3D p = base.PointDest;

            if (p == Point3D.Zero)
                p = m.Location;

            // Check for AllowPets here
            if (!Stone.AllowPets && CountPets(m) > 0)
                m.SendMessage(34, "Se svymi zviraty nemuzes do {0} vstoupit.", Stone.DungeonName);
            else
            {
              BaseHire hire = BaseHire.HireTable[m] as BaseHire;
              QuestJar qj = m.Backpack.FindItemByType( typeof(QuestJar) ) as QuestJar;
              
              if( hire != null && !hire.Deleted && hire.GetOwner() == m && hire is Medic && m.AccessLevel == AccessLevel.Player )
              {
                  m.SendMessage(34, "S najmutym pomocnikem nemuzes do {0} vstoupit.", Stone.DungeonName);
              }
              else if( qj == null || !qj.isFull || qj.Owner != m )
              {
                  m.SendMessage(34, "Musis mit u sebe naplnenou nadobku aby jsi mohl vstoupit do {0} a bojovat s drakem Auberonem.", Stone.DungeonName);
              }
              else
              {
                  Server.Mobiles.BaseCreature.TeleportPets(m, p, map);
                      
                  bool sendEffect = (!m.Hidden || m.AccessLevel == AccessLevel.Player);
      
                  if (base.SourceEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  m.MoveToWorld(p, map);
      
                  if (base.DestEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  if (base.SoundID > 0 && sendEffect)
                      Effects.PlaySound(m.Location, m.Map, base.SoundID);
              }
            }
        }
      
		public AuberonTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
   }
   
   public class DFTeleporter : GroupDungeonTeleporter
   {
      [Constructable]
		public DFTeleporter()
		{
		    Name = "Dark Father Event";
		    Hue = 1060;
		    ItemID = 3948;
      }
      
        public override bool OnMoveOver(Mobile m)
        {
            if ( m == null ) return false;
            
            if (Stone != null)
            {
                if (Stone.IRegion != null)
                {
                    if (Stone.IRegion.CanEnter(m))
                        return base.OnMoveOver(m);
                }
                else
                    m.SendMessage(34, "Teleporter not linked to a dungeon region. Contact staff.");
            }
            else
                m.SendMessage(34, "Teleporter not linked to a dungeon stone. Contact staff.");
            return true;
        }
      
        public override void DoTeleport(Mobile m)
        {
            if ( m == null ) return;
            
            Map map = base.MapDest;

            if (map == null || map == Map.Internal)
                map = m.Map;

            Point3D p = base.PointDest;

            if (p == Point3D.Zero)
                p = m.Location;

            // Check for AllowPets here
            if (!Stone.AllowPets && CountPets(m) > 0)
                m.SendMessage(34, "Se svymi zviraty nemuzes do {0} vstoupit.", Stone.DungeonName);
            else
            {
              PoukazkaNaDF poukazka = m.Backpack.FindItemByType( typeof(PoukazkaNaDF) ) as PoukazkaNaDF;
              
              if( poukazka == null && m.AccessLevel == AccessLevel.Player )
              {
      		    if ( m.BeginAction( this ) )
      		    {
      			   m.SendMessage(34, "Musis mit v batohu poukazku na DF" );
      
      			   Timer.DelayCall( TimeSpan.FromSeconds( 5.0 ), new TimerStateCallback( EndMessageLock ), m );
      		    }
              }
              else
              {
                  if( poukazka != null && m.AccessLevel == AccessLevel.Player )
                     poukazka.Delete();
                     
                  Server.Mobiles.BaseCreature.TeleportPets(m, p, map);
                      
                  bool sendEffect = (!m.Hidden || m.AccessLevel == AccessLevel.Player);
      
                  if (base.SourceEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  m.MoveToWorld(p, map);
      
                  if (base.DestEffect && sendEffect)
                      Effects.SendLocationEffect(m.Location, m.Map, 0x3728, 10, 10);
      
                  if (base.SoundID > 0 && sendEffect)
                      Effects.PlaySound(m.Location, m.Map, base.SoundID);
              }
            }
        }
        
		private void EndMessageLock( object state )
		{
			((Mobile)state).EndAction( this );
		}
      
		public DFTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
   }  
}